## Communicate Externally

### Notify Regulators

* **Do not** notify or update non-response personnel until cleared by the Incident Commander.
* Notify regulators (_e.g._, HIPAA/HITRUST, PCI DSS, SOX) if necessary, and in accordance with policy.
* Coordinate requirements, format, and timeline with {{COMPLIANCE_TEAM}}.

### Notify Customers

* **Do not** notify or update non-response personnel until cleared by the Incident Commander.
* Coordinate customer notifications with {{COMMUNICATIONS_TEAM}}.
* Include the date in the title of any announcement, to avoid confusion.
* **Do not** use platitudes such as "we take security very seriously". Focus on facts.
* Be honest, accept responsibility, and present the facts, along with the plan to prevent similar incidents in future.
* Be as detailed as possible with the timeline.
* Be as detailed as possible in what information was compromised, and how it affects customers. If we were storing something we shouldn't have been, be honest about it. It'll come out later and it'll be much worse.
* **Do not** discuss external parties that might have caused the compromise, unless they've already publicly disclosed, in which case link to their disclosure.  Communicate with them independently (see [Notify Vendors](#notify-vendors-and-partners))
* Release the external communication as soon as possible.  Bad news does not get better with age.
* If possible, contact customers' internal security teams before notifying the public.

### Notify Vendors and Partners

* **Do not** notify or update non-response personnel until cleared by the Incident Commander.
* If possible, contact vendors' and partners' internal security teams before notifying the public.
* Focus on the specific aspects of the incident that affect or implicate the vendor or partner.
* Coordinate response efforts and share information if possible.

### Notify Law Enforcement

* **Do not** notify or update non-response personnel until cleared by the Incident Commander.
* Coordinate with {{EXECUTIVE_TEAM}} and {{LEGAL_TEAM}} prior to interacting with law enforcement
* Contact local law enforcement at {{LOCAL_LE_CONTACT}}.
* Contact FBI at {{FBI_CONTACT}} or via the [Internet Crime Complaint Center (IC3)](https://www.ic3.gov).
* Contact operators for any systems used in the attack, their systems may also have been compromised.

### Contact External Response Support

* Contact {{INCIDENT_RESPONSE_VENDOR}} to help in assessing risk, incident management, incident response, and post-incident support.
* Contact {{PUBLIC_RELATIONS_VENDOR}} for help with PR and external communication.
* Contact {{INSURANCE_VENDOR}} for help with cyber insurance.

### Share Intelligence

* Share IOCs with [Infragard](https://www.infragard.org/) if applicable.
* Share IOCs with your servicing [ISAC](https://en.wikipedia.org/wiki/Information_Sharing_and_Analysis_Center) through {{ISAC_CONTACT}}, if applicable.
